﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Xml

Public Class MainForm

    ''' <summary>
    '''此方法符合 Automobile 类中的 ReplaceSparkPlugs 委托。
    ''' </summary>
    ''' <param name="description"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ReplacePlugs(ByVal description As String) As Boolean

    End Function

    ''' <summary>
    '''用于检查 XML 注释的 car 的实例。
    ''' </summary>
    ''' <remarks></remarks>
    Dim WithEvents car As New Automobile()

    Private Sub createCar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles createCar.Click
        Dim towing As Integer = car.CalculateMaxTowing()
        Dim replace As New Automobile.ReplaceSparkPlugs(AddressOf ReplacePlugs)
        MsgBox("Car created.")
    End Sub

    Private Sub car_NeedsTuneUp(ByVal sender As Object, ByVal e As System.EventArgs) Handles car.NeedsTuneUp

    End Sub

    Private Sub listSummaries_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles listSummaries.Click
        'XML 标记存储在一个 XML 文件中，该文件与程序集在一起。
        Dim xmlDoc As New XmlDocument
        xmlDoc.Load(My.Application.Info.DirectoryPath & "\XmlComments.xml")
        Dim output As String = ""
        Dim summary As XmlNode = Nothing
        Dim name As String = ""
        Dim members As XmlNodeList = xmlDoc.GetElementsByTagName("member")
        For Each member As XmlNode In members
            'name 属性含有成员名称。
            name = member.Attributes("name").Value
            '使名称更具可读性。
            name = name.Replace("T:", "Type: ")
            name = name.Replace("M:", "Type: ")
            name = name.Replace("E:", "Event: ")
            name = name.Replace("F:", "Field: ")
            name = name.Replace("P:", "Property: ")
            name = name.Replace("#ctor", "New")
            name = name.Replace("XmlComments.", "")
            output &= name & ":"
            'summary 元素含有摘要注释。
            summary = member.SelectSingleNode("summary")
            output &= summary.InnerText & vbCrLf
        Next
        MsgBox(output)
    End Sub

    Private Sub exitToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class

